/*
 * Decompiled with CFR 0.152.
 */
package com.github.tennaito.rsql.jpa;

import com.github.tennaito.rsql.builder.BuilderTools;
import com.github.tennaito.rsql.jpa.JpaPathCache;
import com.github.tennaito.rsql.parser.ast.ComparisonOperatorProxy;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import cz.jirutka.rsql.parser.ast.Node;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PredicateBuilder {
    public static final Character LIKE_WILDCARD = Character.valueOf('*');
    private static final Logger LOG = Logger.getLogger(PredicateBuilder.class.getName());
    private static final Date START_DATE;
    private static final Date END_DATE;

    private PredicateBuilder() {
    }

    public static <T> Predicate createPredicate(Node node, From root, Class<T> entity, EntityManager manager, BuilderTools misc) {
        if (root == null) {
            String msg = "From root node was undefined.";
            LOG.log(Level.SEVERE, msg);
            throw new IllegalArgumentException(msg);
        }
        JpaPathCache pathCache = new JpaPathCache(root, manager.getMetamodel(), misc);
        return PredicateBuilder.createPredicate(node, pathCache, entity, manager, misc);
    }

    private static <T> Predicate createPredicate(Node node, JpaPathCache pathCache, Class<T> entity, EntityManager manager, BuilderTools misc) {
        LOG.log(Level.INFO, "Creating Predicate for: {0}", node);
        if (node instanceof LogicalNode) {
            return PredicateBuilder.createPredicate((LogicalNode)node, pathCache, entity, manager, misc);
        }
        if (node instanceof ComparisonNode) {
            return PredicateBuilder.createPredicate((ComparisonNode)node, pathCache, entity, manager, misc);
        }
        throw new IllegalArgumentException("Unknown expression type: " + node.getClass());
    }

    private static <T> Predicate createPredicate(LogicalNode logical, JpaPathCache pathCache, Class<T> entity, EntityManager entityManager, BuilderTools misc) {
        LOG.log(Level.INFO, "Creating Predicate for logical node: {0}", logical);
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        LOG.log(Level.INFO, "Creating Predicates from all children nodes.");
        for (Node node : logical.getChildren()) {
            predicates.add(PredicateBuilder.createPredicate(node, pathCache, entity, entityManager, misc));
        }
        switch (logical.getOperator()) {
            case AND: {
                return builder.and(predicates.toArray(new Predicate[predicates.size()]));
            }
            case OR: {
                return builder.or(predicates.toArray(new Predicate[predicates.size()]));
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + logical.getOperator());
    }

    private static <T> Predicate createPredicate(ComparisonNode comparison, JpaPathCache pathCache, Class<T> entity, EntityManager entityManager, BuilderTools misc) {
        LOG.log(Level.INFO, "Creating Predicate for comparison node: {0}", comparison);
        LOG.log(Level.INFO, "Property graph path : {0}", comparison.getSelector());
        Path propertyPath = pathCache.getPath(comparison.getSelector());
        LOG.log(Level.INFO, "Cast all arguments to type {0}.", propertyPath.getJavaType().getName());
        List<Object> castedArguments = misc.getArgumentParser().parse(comparison.getArguments(), propertyPath.getJavaType());
        try {
            return PredicateBuilder.createPredicate((Expression)propertyPath, comparison.getOperator(), castedArguments, entityManager);
        }
        catch (IllegalArgumentException e) {
            if (misc.getPredicateBuilder() != null) {
                return misc.getPredicateBuilder().createPredicate((Node)comparison, (From)pathCache.getPath(""), entity, entityManager, misc);
            }
            throw e;
        }
    }

    private static Predicate createPredicate(Expression propertyPath, ComparisonOperator operator, List<Object> arguments, EntityManager manager) {
        LOG.log(Level.INFO, "Creating predicate: propertyPath {0} {1}", new Object[]{operator, arguments});
        if (ComparisonOperatorProxy.asEnum(operator) != null) {
            switch (ComparisonOperatorProxy.asEnum(operator)) {
                case EQUAL: {
                    Object argument = arguments.get(0);
                    if (argument instanceof String) {
                        return PredicateBuilder.createLike((Expression<String>)propertyPath, (String)argument, manager);
                    }
                    if (PredicateBuilder.isNullArgument(argument)) {
                        return PredicateBuilder.createIsNull(propertyPath, manager);
                    }
                    return PredicateBuilder.createEqual(propertyPath, argument, manager);
                }
                case NOT_EQUAL: {
                    Object argument = arguments.get(0);
                    if (argument instanceof String) {
                        return PredicateBuilder.createNotLike((Expression<String>)propertyPath, (String)argument, manager);
                    }
                    if (PredicateBuilder.isNullArgument(argument)) {
                        return PredicateBuilder.createIsNotNull(propertyPath, manager);
                    }
                    return PredicateBuilder.createNotEqual(propertyPath, argument, manager);
                }
                case GREATER_THAN: {
                    Predicate predicate;
                    Object argument = arguments.get(0);
                    if (argument instanceof Date) {
                        int days = 1;
                        predicate = PredicateBuilder.createBetweenThan(propertyPath, PredicateBuilder.modifyDate(argument, days), END_DATE, manager);
                    } else if (argument instanceof Number || argument == null) {
                        predicate = PredicateBuilder.createGreaterThan((Expression<? extends Number>)propertyPath, (Number)argument, manager);
                    } else if (argument instanceof Comparable) {
                        predicate = PredicateBuilder.createGreaterThanComparable(propertyPath, (Comparable)argument, manager);
                    } else {
                        throw new IllegalArgumentException(PredicateBuilder.buildNotComparableMessage(operator, argument));
                    }
                    return predicate;
                }
                case GREATER_THAN_OR_EQUAL: {
                    Predicate predicate;
                    Object argument = arguments.get(0);
                    if (argument instanceof Date) {
                        predicate = PredicateBuilder.createBetweenThan(propertyPath, (Date)argument, END_DATE, manager);
                    } else if (argument instanceof Number || argument == null) {
                        predicate = PredicateBuilder.createGreaterEqual((Expression<? extends Number>)propertyPath, (Number)argument, manager);
                    } else if (argument instanceof Comparable) {
                        predicate = PredicateBuilder.createGreaterEqualComparable(propertyPath, (Comparable)argument, manager);
                    } else {
                        throw new IllegalArgumentException(PredicateBuilder.buildNotComparableMessage(operator, argument));
                    }
                    return predicate;
                }
                case LESS_THAN: {
                    Predicate predicate;
                    Object argument = arguments.get(0);
                    if (argument instanceof Date) {
                        int days = -1;
                        predicate = PredicateBuilder.createBetweenThan(propertyPath, START_DATE, PredicateBuilder.modifyDate(argument, days), manager);
                    } else if (argument instanceof Number || argument == null) {
                        predicate = PredicateBuilder.createLessThan((Expression<? extends Number>)propertyPath, (Number)argument, manager);
                    } else if (argument instanceof Comparable) {
                        predicate = PredicateBuilder.createLessThanComparable(propertyPath, (Comparable)argument, manager);
                    } else {
                        throw new IllegalArgumentException(PredicateBuilder.buildNotComparableMessage(operator, argument));
                    }
                    return predicate;
                }
                case LESS_THAN_OR_EQUAL: {
                    Predicate predicate;
                    Object argument = arguments.get(0);
                    if (argument instanceof Date) {
                        predicate = PredicateBuilder.createBetweenThan(propertyPath, START_DATE, (Date)argument, manager);
                    } else if (argument instanceof Number || argument == null) {
                        predicate = PredicateBuilder.createLessEqual((Expression<? extends Number>)propertyPath, (Number)argument, manager);
                    } else if (argument instanceof Comparable) {
                        predicate = PredicateBuilder.createLessEqualComparable(propertyPath, (Comparable)argument, manager);
                    } else {
                        throw new IllegalArgumentException(PredicateBuilder.buildNotComparableMessage(operator, argument));
                    }
                    return predicate;
                }
                case IN: {
                    return PredicateBuilder.createIn(propertyPath, arguments, manager);
                }
                case NOT_IN: {
                    return PredicateBuilder.createNotIn(propertyPath, arguments, manager);
                }
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + operator);
    }

    private static Predicate createBetweenThan(Expression propertyPath, Date start, Date end, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.between(propertyPath, (Comparable)start, (Comparable)end);
    }

    private static Predicate createLike(Expression<String> propertyPath, String argument, EntityManager manager) {
        String like = argument.replace(LIKE_WILDCARD.charValue(), '%');
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.like(builder.lower(propertyPath), like.toLowerCase());
    }

    private static Predicate createIsNull(Expression<?> propertyPath, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.isNull(propertyPath);
    }

    private static Predicate createEqual(Expression<?> propertyPath, Object argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.equal(propertyPath, argument);
    }

    private static Predicate createNotEqual(Expression<?> propertyPath, Object argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.notEqual(propertyPath, argument);
    }

    private static Predicate createNotLike(Expression<String> propertyPath, String argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.not((Expression)PredicateBuilder.createLike(propertyPath, argument, manager));
    }

    private static Predicate createIsNotNull(Expression<?> propertyPath, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.isNotNull(propertyPath);
    }

    private static Predicate createGreaterThan(Expression<? extends Number> propertyPath, Number argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.gt(propertyPath, argument);
    }

    private static <Y extends Comparable<? super Y>> Predicate createGreaterThanComparable(Expression<? extends Y> propertyPath, Y argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.greaterThan(propertyPath, argument);
    }

    private static Predicate createGreaterEqual(Expression<? extends Number> propertyPath, Number argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.ge(propertyPath, argument);
    }

    private static <Y extends Comparable<? super Y>> Predicate createGreaterEqualComparable(Expression<? extends Y> propertyPath, Y argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.greaterThanOrEqualTo(propertyPath, argument);
    }

    private static Predicate createLessThan(Expression<? extends Number> propertyPath, Number argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.lt(propertyPath, argument);
    }

    private static <Y extends Comparable<? super Y>> Predicate createLessThanComparable(Expression<? extends Y> propertyPath, Y argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.lessThan(propertyPath, argument);
    }

    private static Predicate createLessEqual(Expression<? extends Number> propertyPath, Number argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.le(propertyPath, argument);
    }

    private static <Y extends Comparable<? super Y>> Predicate createLessEqualComparable(Expression<? extends Y> propertyPath, Y argument, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.lessThanOrEqualTo(propertyPath, argument);
    }

    private static Predicate createIn(Expression<?> propertyPath, List<?> arguments, EntityManager manager) {
        return propertyPath.in(arguments);
    }

    private static Predicate createNotIn(Expression<?> propertyPath, List<?> arguments, EntityManager manager) {
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        return builder.not((Expression)PredicateBuilder.createIn(propertyPath, arguments, manager));
    }

    private static <T> boolean hasPropertyName(String property, ManagedType<T> classMetadata) {
        Set names = classMetadata.getAttributes();
        for (Attribute name : names) {
            if (!name.getName().equals(property)) continue;
            return true;
        }
        return false;
    }

    private static <T> Class<?> findPropertyType(Attribute attribMeta) {
        if (attribMeta.isCollection()) {
            return ((PluralAttribute)attribMeta).getBindableJavaType();
        }
        return attribMeta.getJavaType();
    }

    private static boolean isNullArgument(Object argument) {
        return argument == null;
    }

    private static Date modifyDate(Object argument, int days) {
        Date date = (Date)argument;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, days);
        date = c.getTime();
        return date;
    }

    private static String buildNotComparableMessage(ComparisonOperator operator, Object argument) {
        return String.format("Invalid type for comparison operator: %s type: %s must implement Comparable<%s>", operator, argument.getClass().getName(), argument.getClass().getSimpleName());
    }

    static {
        Calendar cal = Calendar.getInstance();
        cal.set(9999, 11, 31);
        END_DATE = cal.getTime();
        cal.set(5, 0, 1);
        START_DATE = cal.getTime();
    }
}

