package br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl;


import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;


public class OrSpecification<T> extends JPASpecification<T> {

	private JPASpecification<T> first;
	private JPASpecification<T> second;

	public OrSpecification(JPASpecification<T> first, JPASpecification<T> second) {
		this.first = first;
		this.second = second;
	}

	@Override
	public Predicate toPredicate(Root<T> root, CriteriaBuilder cb) {
		return cb.or(first.toPredicate(root, cb), second.toPredicate(root, cb));
	}
	
	@Override
	public boolean isSatisfiedBy(T element) {
		return first.isSatisfiedBy(element) || second.isSatisfiedBy(element);
	}

	@Override
	public Class<T> getType() {
		return first.getType();
	}
	
}
