/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl;

import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.Repository;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public abstract class JPARepository<C>
implements Repository<C, JPASpecification<C>> {
    @Override
    public void add(C element) {
        this.getEntityManager().persist(element);
    }

    @Override
    public void remove(C element) {
        this.getEntityManager().remove(element);
    }

    @Override
    public void update(C element) {
        this.getEntityManager().flush();
    }

    @Override
    public List<C> find(JPASpecification<C> specification) {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(specification.getType());
        Root root = criteriaQuery.from(specification.getType());
        Predicate predicate = specification.toPredicate(root, criteriaBuilder);
        criteriaQuery.where((Expression)predicate);
        List result = this.getEntityManager().createQuery(criteriaQuery).getResultList();
        return result;
    }

    @Override
    public long count(JPASpecification<C> specification) {
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root root = criteriaQuery.from(specification.getType());
        criteriaQuery.select((Selection)criteriaBuilder.count((Expression)root));
        Predicate predicate = specification.toPredicate(root, criteriaBuilder);
        criteriaQuery.where((Expression)predicate);
        long result = (Long)this.getEntityManager().createQuery(criteriaQuery).getSingleResult();
        return result;
    }

    @Override
    public C first(JPASpecification<C> specification) {
        List<C> elements = this.find(specification);
        if (elements.size() == 0) {
            return null;
        }
        return elements.get(0);
    }

    public abstract EntityManager getEntityManager();
}

