package br.pucrio.tecgraf.soma.serviceapi.persistence.repository;

import java.util.List;

import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.Specification;

public interface Repository<C, S extends Specification<C>> {

	/**
	 * Add an element
	 * @param element to be added
	 */
	public void add(C element);

	/**
	 * Removes element
	 * @param element element to be removed
	 */
	public void remove(C element);

	/**
	 * Updates element
	 * @param element new element
	 */
	public void update(C element);

	/**
	 * Get elements that matches a given specification
	 * @param specification a query specification
	 * @return elements that matches the given specification
	 */
	List<C> find(S specification);

	/**
	 * Count elements that matches a given specification
	 * @param specification a query specification
	 * @return number of elements that matches the given specification
	 */
	long count(S specification);

	/**
	 * Get the first element that matches a given specification
	 * @param specification a query specification
	 * @return the first element that matches the given specification ot null if none matches
	 */
	C first(S specification);
}
