/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.ComparisonFailureFactory;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.util.Arrays;
import org.fest.util.Objects;

public final class Fail {
    public static void fail() {
        Fail.fail(null);
    }

    protected static void failIfEqual(String customErrorMessage, Description descriptionOfActual, Object actual, Object other) {
        if (!Objects.areEqual(actual, other)) {
            return;
        }
        Fail.failWithMessage(customErrorMessage);
        Fail.fail(Formatting.format(descriptionOfActual, ErrorMessages.unexpectedEqual(actual, other)));
    }

    protected static void failIfNotEqual(String customErrorMessage, Description descriptionOfActual, Object actual, Object expected) {
        if (Objects.areEqual(actual, expected)) {
            return;
        }
        Fail.failWithMessage(customErrorMessage);
        Fail.failWhenNotEqual(descriptionOfActual, actual, expected);
    }

    private static void failWhenNotEqual(Description description, Object actual, Object expected) {
        AssertionError comparisonFailure = ComparisonFailureFactory.comparisonFailure(Formatting.valueOf(description), expected, actual);
        if (comparisonFailure != null) {
            throw comparisonFailure;
        }
        Fail.fail(Formatting.format(description, ErrorMessages.unexpectedNotEqual(actual, expected)));
    }

    protected static void failIfNull(String customErrorMessage, Description description, Object o) {
        if (o != null) {
            return;
        }
        Fail.failWithMessage(customErrorMessage);
        Fail.fail(description, Arrays.array("expecting a non-null object, but it was null"));
    }

    protected static void failIfNotNull(String customErrorMessage, Description description, Object o) {
        if (o == null) {
            return;
        }
        Fail.failWithMessage(customErrorMessage);
        Fail.fail(description, Arrays.array(Formatting.inBrackets(o), " should be null"));
    }

    protected static void failIfSame(String customErrorMessage, Description descriptionOfActual, Object actual, Object other) {
        if (actual != other) {
            return;
        }
        Fail.failWithMessage(customErrorMessage);
        Fail.fail(descriptionOfActual, Arrays.array("given objects are same:", Formatting.inBrackets(actual)));
    }

    protected static void failIfNotSame(String customErrorMessage, Description descriptionOfActual, Object actual, Object other) {
        if (actual == other) {
            return;
        }
        Fail.failWithMessage(customErrorMessage);
        Fail.fail(descriptionOfActual, Arrays.array("expected same instance but found:", Formatting.inBrackets(actual), " and:", Formatting.inBrackets(other)));
    }

    private static void fail(Description description, Object[] message) {
        throw Fail.failure(Formatting.createMessageFrom(description, message));
    }

    protected static void failWithMessage(String customErrorMessage) {
        if (customErrorMessage != null) {
            Fail.fail(customErrorMessage);
        }
    }

    protected static void failWithMessage(String customErrorMessage, Throwable realCause) {
        if (customErrorMessage != null) {
            Fail.fail(customErrorMessage, realCause);
        }
    }

    public static void fail(String description, Throwable realCause) {
        AssertionError error = Fail.failure(description);
        ((Throwable)((Object)error)).initCause(realCause);
        throw error;
    }

    public static AssertionError fail(String message) {
        throw Fail.failure(message);
    }

    public static AssertionError failure(String message) {
        return new AssertionError((Object)message);
    }

    protected Fail() {
    }
}

