/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.data;

import javax.swing.JTable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.data.TableCell;
import org.fest.swing.data.TableCellFinder;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Strings;

public class TableCellInSelectedRow
implements TableCellFinder {
    private final int column;

    public static TableCellBuilder selectedRow() {
        return new TableCellBuilder();
    }

    protected TableCellInSelectedRow(int column) {
        this.column = column;
    }

    public TableCell findCell(JTable table, JTableCellReader cellReader) {
        int selectedRow = TableCellInSelectedRow.selectedRowOf(table);
        if (selectedRow == -1) {
            throw ActionFailedException.actionFailure("The given JTable does not have any selection");
        }
        return new TableCell(selectedRow, this.column);
    }

    @RunsInEDT
    private static int selectedRowOf(final JTable table) {
        return GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            protected Integer executeInEDT() {
                return table.getSelectedRow();
            }
        });
    }

    public String toString() {
        return Strings.concat(this.getClass().getName(), "[column=", String.valueOf(this.column), "]");
    }

    public static class TableCellBuilder {
        public TableCellInSelectedRow column(int column) {
            return new TableCellInSelectedRow(column);
        }
    }
}

