/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.format.Formatting;
import org.fest.util.Strings;

public final class ComponentStateValidator {
    @RunsInCurrentThread
    public static void validateIsEnabledAndShowing(Component c) {
        ComponentStateValidator.validateIsEnabled(c);
        ComponentStateValidator.validateIsShowing(c);
    }

    @RunsInCurrentThread
    public static void validateIsEnabled(Component c) {
        if (!c.isEnabled()) {
            throw new IllegalStateException(Strings.concat("Expecting component ", Formatting.format(c), " to be enabled"));
        }
    }

    @RunsInCurrentThread
    public static void validateIsShowing(Component c) {
        if (!c.isShowing()) {
            throw ComponentStateValidator.componentNotShowingOnScreenFailure(c);
        }
    }

    @RunsInCurrentThread
    public static IllegalStateException componentNotShowingOnScreenFailure(Component c) {
        return new IllegalStateException(Strings.concat("Expecting component ", Formatting.format(c), " to be showing on the screen"));
    }

    private ComponentStateValidator() {
    }
}

