/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.edt;

import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.fest.swing.edt.GuiAction;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.exception.UnexpectedException;
import org.fest.util.Throwables;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class GuiActionRunner {
    @GuardedBy(value="this")
    private static boolean executeInEDT = true;

    public static synchronized void executeInEDT(boolean b) {
        executeInEDT = b;
    }

    public static synchronized boolean executeInEDT() {
        return executeInEDT;
    }

    public static <T> T execute(GuiQuery<T> query) {
        if (!executeInEDT) {
            return GuiActionRunner.executeInCurrentThread(query);
        }
        GuiActionRunner.run(query);
        return GuiActionRunner.resultOf(query);
    }

    private static <T> T executeInCurrentThread(GuiQuery<T> query) {
        try {
            return query.executeInEDT();
        }
        catch (Throwable e) {
            throw UnexpectedException.unexpected(e);
        }
    }

    public static void execute(GuiTask task) {
        if (!executeInEDT) {
            GuiActionRunner.executeInCurrentThread(task);
            return;
        }
        GuiActionRunner.run(task);
        GuiActionRunner.rethrowCatchedExceptionIn(task);
    }

    private static void executeInCurrentThread(GuiTask task) {
        try {
            task.executeInEDT();
        }
        catch (Throwable e) {
            throw UnexpectedException.unexpected(e);
        }
    }

    private static void run(GuiAction action) {
        if (SwingUtilities.isEventDispatchThread()) {
            action.run();
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        action.executionNotification(latch);
        SwingUtilities.invokeLater(action);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static <T> T resultOf(GuiQuery<T> query) {
        T result = query.result();
        query.clearResult();
        GuiActionRunner.rethrowCatchedExceptionIn(query);
        return result;
    }

    private static void rethrowCatchedExceptionIn(GuiAction action) {
        Throwable catchedException = action.catchedException();
        action.clearCatchedException();
        if (catchedException == null) {
            return;
        }
        if (catchedException instanceof RuntimeException) {
            Throwables.appendCurrentThreadStackTraceToThrowable(catchedException, "execute");
            throw (RuntimeException)catchedException;
        }
        if (catchedException instanceof Error) {
            catchedException.fillInStackTrace();
            throw (Error)catchedException;
        }
        throw UnexpectedException.unexpected(catchedException);
    }
}

