/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.finder;

import java.awt.Component;
import java.util.concurrent.TimeUnit;
import org.fest.swing.core.ComponentFoundCondition;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.core.NameMatcher;
import org.fest.swing.core.Robot;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.timing.Condition;
import org.fest.swing.timing.Pause;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentFinderTemplate<T extends Component> {
    static final long TIMEOUT = 5000L;
    private long timeout = 5000L;
    private final ComponentMatcher matcher;
    private final String searchDescription;

    protected ComponentFinderTemplate(String componentName, Class<? extends T> componentType) {
        this(new NameMatcher(componentName, componentType, true));
    }

    protected ComponentFinderTemplate(GenericTypeMatcher<? extends T> matcher) {
        this((ComponentMatcher)matcher);
    }

    protected ComponentFinderTemplate(Class<? extends T> componentType) {
        this(new TypeMatcher(componentType, true));
    }

    private ComponentFinderTemplate(ComponentMatcher matcher) {
        if (matcher == null) {
            throw new NullPointerException("The matcher should not be null");
        }
        this.matcher = matcher;
        this.searchDescription = Strings.concat("component to be found using matcher ", matcher);
    }

    protected ComponentFinderTemplate<T> withTimeout(long newTimeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("Time unit cannot be null");
        }
        return this.withTimeout(unit.toMillis(newTimeout));
    }

    protected ComponentFinderTemplate<T> withTimeout(long newTimeout) {
        if (newTimeout < 0L) {
            throw new IllegalArgumentException("Timeout cannot be a negative number");
        }
        this.timeout = newTimeout;
        return this;
    }

    public abstract ComponentFixture<T> using(Robot var1);

    protected final T findComponentWith(Robot robot) {
        ComponentFoundCondition condition = new ComponentFoundCondition(this.searchDescription, robot.finder(), this.matcher);
        Pause.pause((Condition)condition, this.timeout);
        return this.cast(condition.found());
    }

    protected abstract T cast(Component var1);
}

