/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.junit.xml;

import org.fest.swing.junit.xml.XmlAttribute;
import org.fest.swing.junit.xml.XmlAttributes;
import org.fest.util.Objects;
import org.fest.util.Strings;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XmlNode {
    private final Element target;

    protected XmlNode(Element target) {
        this.target = target;
    }

    public XmlNode addNewNode(String name) {
        return new XmlNode(this.createAndAddChild(name));
    }

    public XmlNode addNewNode(String name, XmlAttributes attributes) {
        Element e = this.createAndAddChild(name);
        for (XmlAttribute a : attributes) {
            XmlNode.addAttribute(e, a);
        }
        return new XmlNode(e);
    }

    private Element createAndAddChild(String name) {
        Element e = this.document().createElement(name);
        this.target.appendChild(e);
        return e;
    }

    public void addCdata(String data) {
        CDATASection s = this.document().createCDATASection(data);
        this.target.appendChild(s);
    }

    public void addText(String text) {
        Text textNode = this.document().createTextNode(text);
        this.target.appendChild(textNode);
    }

    private Document document() {
        return this.target.getOwnerDocument();
    }

    public void addAttribute(XmlAttribute a) {
        XmlNode.addAttribute(this.target, a);
    }

    public void addAttributes(XmlAttribute ... attributes) {
        for (XmlAttribute a : attributes) {
            XmlNode.addAttribute(this.target, a);
        }
    }

    private static void addAttribute(Element e, XmlAttribute a) {
        e.setAttribute(a.name(), a.value());
    }

    public Element target() {
        return this.target;
    }

    public XmlNode parentNode() {
        return XmlNode.xmlNodeFrom(this.target.getParentNode());
    }

    public int size() {
        return this.target.getChildNodes().getLength();
    }

    public XmlNode child(int index) {
        return XmlNode.xmlNodeFrom(this.target.getChildNodes().item(index));
    }

    private static XmlNode xmlNodeFrom(Node n) {
        if (!(n instanceof Element)) {
            return null;
        }
        return new XmlNode((Element)n);
    }

    public String valueOfAttribute(String name) {
        return this.target.getAttribute(name);
    }

    public String name() {
        return this.target.getNodeName();
    }

    public String text() {
        return this.target.getTextContent();
    }

    public int attributeCount() {
        return this.target.getAttributes().getLength();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XmlNode other = (XmlNode)obj;
        return this.target.isEqualNode(other.target);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor(this.name());
        return result;
    }

    public String toString() {
        return Strings.concat(this.getClass().getSimpleName(), "[", "target=", this.target, "]");
    }
}

