/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.util.regex.Pattern;
import org.fest.util.Arrays;

public final class Patterns {
    public static String format(Pattern[] patterns) {
        if (patterns == null) {
            throw new NullPointerException("The array of patterns should not be null");
        }
        int patternCount = patterns.length;
        String[] patternsAsText = new String[patternCount];
        for (int i = 0; i < patternCount; ++i) {
            patternsAsText[i] = Patterns.patternValueOf(patterns[i]);
        }
        return Arrays.format(patternsAsText);
    }

    private static String patternValueOf(Pattern pattern) {
        if (pattern == null) {
            throw new NullPointerException("The array of patterns should not contain null values");
        }
        return pattern.pattern();
    }

    private Patterns() {
    }
}

