/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.icon.EmptyIcon;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.painter.HighlightPainterUtils;
import org.pushingpixels.substance.internal.utils.RolloverControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;
import org.pushingpixels.substance.swingx.SubstanceSwingxFillBackgroundDelegate;

public class SubstanceTaskPaneUI
extends BasicTaskPaneUI
implements TransitionAwareUI {
    protected Set lafWidgets;
    private SubstanceSwingxFillBackgroundDelegate bgDelegate = new SubstanceSwingxFillBackgroundDelegate();
    private RolloverControlListener substanceRolloverListener;
    protected StateTransitionTracker stateTransitionTracker;
    protected ButtonModel taskPaneModel = new DefaultButtonModel();

    public void __org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void installListeners() {
        this.__org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void installDefaults() {
        this.__org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.__org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.__org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation((Component)comp);
        return new SubstanceTaskPaneUI((JXTaskPane)comp);
    }

    public SubstanceTaskPaneUI(JXTaskPane taskPane) {
        this.taskPaneModel.setArmed(false);
        this.taskPaneModel.setSelected(false);
        this.taskPaneModel.setPressed(false);
        this.taskPaneModel.setRollover(false);
        this.stateTransitionTracker = new StateTransitionTracker((JComponent)taskPane, this.taskPaneModel);
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__installListeners() {
        super.installListeners();
        this.substanceRolloverListener = new RolloverControlListener((TransitionAwareUI)this, this.taskPaneModel);
        this.group.addMouseListener((MouseListener)this.substanceRolloverListener);
        this.group.addMouseMotionListener((MouseMotionListener)this.substanceRolloverListener);
        this.stateTransitionTracker.registerModelListeners();
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__uninstallListeners() {
        this.group.removeMouseListener((MouseListener)this.substanceRolloverListener);
        this.group.removeMouseMotionListener((MouseMotionListener)this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        super.uninstallListeners();
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__installDefaults() {
        SubstanceLookAndFeel.setDecorationType((JComponent)this.group, (DecorationAreaType)DecorationAreaType.GENERAL);
        super.installDefaults();
    }

    public void __org__pushingpixels__substance__swingx__SubstanceTaskPaneUI__uninstallUI(JComponent c) {
        DecorationPainterUtils.clearDecorationType((JComponent)this.group);
        super.uninstallUI(c);
    }

    @Override
    protected Border createPaneBorder() {
        return new SubstancePaneBorder();
    }

    @Override
    protected Border createContentPaneBorder() {
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)this.group, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)ComponentState.ENABLED);
        final Color borderColor = colorScheme.isDark() ? colorScheme.getDarkColor() : SubstanceColorUtilities.getInterpolatedColor((Color)colorScheme.getMidColor(), (Color)colorScheme.getDarkColor(), (double)0.4);
        Border outer = new Border(){

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setColor(borderColor);
                g2d.drawLine(x, y, x, y + height - 1);
                g2d.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
                g2d.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
                g2d.dispose();
            }

            @Override
            public boolean isBorderOpaque() {
                return true;
            }

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(0, 1, 1, 1);
            }
        };
        return new CompoundBorder(outer, new EmptyBorder(1, 2, 2, 2));
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.bgDelegate.paint(c, (Graphics2D)g, false);
    }

    public boolean isInside(MouseEvent me) {
        return this.isInBorder(me);
    }

    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    protected int getTitleHeight(Component c) {
        return SubstanceSizeUtils.getAdjustedSize((int)SubstanceSizeUtils.getComponentFontSize((Component)c), (int)super.getTitleHeight(c), (int)2, (int)3, (boolean)false);
    }

    protected class SubstancePaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        protected Icon expandedIcon;
        protected Icon collapsedIcon;

        public SubstancePaneBorder() {
            this.borderColor = SubstanceColorSchemeUtilities.getColorScheme((Component)SubstanceTaskPaneUI.this.group, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.BORDER, (ComponentState)ComponentState.ENABLED).getMidColor();
            TransitionAwareIcon.ColorSchemeAssociationKindDelegate colorSchemeAssociationDelegate = new TransitionAwareIcon.ColorSchemeAssociationKindDelegate(){

                public ColorSchemeAssociationKind getColorSchemeAssociationKind(ComponentState state) {
                    if (!state.isDisabled() && state != ComponentState.ENABLED) {
                        return ColorSchemeAssociationKind.HIGHLIGHT;
                    }
                    return ColorSchemeAssociationKind.MARK;
                }
            };
            this.expandedIcon = new TransitionAwareIcon((JComponent)SubstanceTaskPaneUI.this.group, new TransitionAwareIcon.TransitionAwareUIDelegate(){

                public TransitionAwareUI getTransitionAwareUI() {
                    return (TransitionAwareUI)SubstanceTaskPaneUI.this.group.getUI();
                }
            }, new TransitionAwareIcon.Delegate(){

                public Icon getColorSchemeIcon(SubstanceColorScheme scheme) {
                    return SubstanceImageCreator.getDoubleArrowIconDelta((int)SubstanceSizeUtils.getComponentFontSize((Component)SubstanceTaskPaneUI.this.group), (float)0.0f, (float)3.0f, (float)0.0f, (int)1, (SubstanceColorScheme)scheme);
                }
            }, colorSchemeAssociationDelegate, "substance.swingx.taskpane.expanded");
            this.collapsedIcon = new TransitionAwareIcon((JComponent)SubstanceTaskPaneUI.this.group, new TransitionAwareIcon.TransitionAwareUIDelegate(){

                public TransitionAwareUI getTransitionAwareUI() {
                    return (TransitionAwareUI)SubstanceTaskPaneUI.this.group.getUI();
                }
            }, new TransitionAwareIcon.Delegate(){

                public Icon getColorSchemeIcon(SubstanceColorScheme scheme) {
                    return SubstanceImageCreator.getDoubleArrowIconDelta((int)SubstanceSizeUtils.getComponentFontSize((Component)SubstanceTaskPaneUI.this.group), (float)0.0f, (float)3.0f, (float)0.0f, (int)5, (SubstanceColorScheme)scheme);
                }
            }, colorSchemeAssociationDelegate, "substance.swingx.taskpane.collapsed");
            SubstanceLookAndFeel.setDecorationType((JComponent)this.label, (DecorationAreaType)DecorationAreaType.GENERAL);
            this.label.putClientProperty("substancelaf.internal.textUtilities.enforceFgColor", Boolean.TRUE);
        }

        @Override
        protected void paintTitleBackground(JXTaskPane group, Graphics g) {
            Graphics2D graphics = (Graphics2D)g.create();
            StateTransitionTracker.ModelStateInfo modelStateInfo = SubstanceTaskPaneUI.this.stateTransitionTracker.getModelStateInfo();
            Map activeStates = modelStateInfo.getStateContributionMap();
            ComponentState currState = SubstanceTaskPaneUI.this.stateTransitionTracker.getModelStateInfo().getCurrModelState();
            SubstanceColorScheme baseFillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)group, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)currState);
            SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)group, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)currState);
            HighlightPainterUtils.paintHighlight((Graphics)graphics, null, (Component)group, (Rectangle)new Rectangle(0, 0, group.getWidth(), SubstanceTaskPaneUI.this.getTitleHeight(group)), (float)0.5f, null, (SubstanceColorScheme)baseFillScheme, (SubstanceColorScheme)baseBorderScheme);
            for (Map.Entry stateEntry : activeStates.entrySet()) {
                float contribution;
                ComponentState activeState = (ComponentState)stateEntry.getKey();
                if (activeState == currState || (contribution = ((StateTransitionTracker.StateContributionInfo)stateEntry.getValue()).getContribution()) == 0.0f) continue;
                SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)group, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT, (ComponentState)activeState);
                SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)group, (ColorSchemeAssociationKind)ColorSchemeAssociationKind.HIGHLIGHT_BORDER, (ComponentState)activeState);
                graphics.setComposite(LafWidgetUtilities.getAlphaComposite((Component)group, (float)contribution, (Graphics)g));
                HighlightPainterUtils.paintHighlight((Graphics)graphics, null, (Component)group, (Rectangle)new Rectangle(0, 0, group.getWidth(), SubstanceTaskPaneUI.this.getTitleHeight(group)), (float)0.5f, null, (SubstanceColorScheme)fillScheme, (SubstanceColorScheme)borderScheme);
            }
            graphics.dispose();
        }

        @Override
        protected Color getPaintColor(JXTaskPane group) {
            StateTransitionTracker.ModelStateInfo modelStateInfo = SubstanceTaskPaneUI.this.stateTransitionTracker.getModelStateInfo();
            Map activeStates = modelStateInfo.getStateContributionMap();
            ComponentState currState = SubstanceTaskPaneUI.this.stateTransitionTracker.getModelStateInfo().getCurrModelState();
            if (currState.isDisabled() || activeStates.size() == 1) {
                return this.getColorSchemeForState(group, currState).getForegroundColor();
            }
            float aggrRed = 0.0f;
            float aggrGreen = 0.0f;
            float aggrBlue = 0.0f;
            for (Map.Entry activeEntry : modelStateInfo.getStateContributionMap().entrySet()) {
                ComponentState activeState = (ComponentState)activeEntry.getKey();
                SubstanceColorScheme scheme = this.getColorSchemeForState(group, activeState);
                Color schemeFg = scheme.getForegroundColor();
                float contribution = ((StateTransitionTracker.StateContributionInfo)activeEntry.getValue()).getContribution();
                aggrRed += (float)schemeFg.getRed() * contribution;
                aggrGreen += (float)schemeFg.getGreen() * contribution;
                aggrBlue += (float)schemeFg.getBlue() * contribution;
            }
            return new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue);
        }

        private SubstanceColorScheme getColorSchemeForState(JXTaskPane group, ComponentState state) {
            ColorSchemeAssociationKind assocKind = ColorSchemeAssociationKind.FILL;
            if (!state.isDisabled() && state != ComponentState.ENABLED) {
                assocKind = ColorSchemeAssociationKind.HIGHLIGHT;
            }
            SubstanceColorScheme currScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)group, (ColorSchemeAssociationKind)assocKind, (ComponentState)state);
            return currScheme;
        }

        @Override
        protected void paintExpandedControls(JXTaskPane group, Graphics g, int x, int y, int width, int height) {
            Icon arrowIcon = group.isCollapsed() ? this.collapsedIcon : this.expandedIcon;
            int dx = (width - arrowIcon.getIconWidth()) / 2;
            int dy = 1 + (height - arrowIcon.getIconHeight()) / 2;
            arrowIcon.paintIcon(group, g, x + dx, y + dy);
        }

        @Override
        protected boolean isMouseOverBorder() {
            return true;
        }

        @Override
        protected void paintFocus(Graphics g, Color paintColor, int x, int y, int width, int height) {
            SubstanceCoreUtilities.paintFocus((Graphics)g, (Component)SubstanceTaskPaneUI.this.group, (Component)SubstanceTaskPaneUI.this.group, (TransitionAwareUI)SubstanceTaskPaneUI.this, (Shape)new Rectangle(x, y, width - 1, height - 1), (Rectangle)this.label.getBounds(), (float)1.0f, (int)0);
        }

        @Override
        protected void configureLabel(JXTaskPane group) {
            this.label.applyComponentOrientation(group.getComponentOrientation());
            this.label.setFont(group.getFont());
            this.label.setText(group.getTitle());
            this.label.setIcon(group.getIcon() == null ? new EmptyIcon() : group.getIcon());
        }
    }
}

